<?php
// Telegram Channel : @ZetaB0t
// Developer : @SpiderM9n

require_once 'config.php';

function fa_num_to_en($text) {
    $fa_digits = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
    $en_digits = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];
    return str_replace($fa_digits, $en_digits, $text);
}

function save_user($user_id) {
    if (!file_exists(USERS_FILE)) {
        file_put_contents(USERS_FILE, '');
    }
    
    $users = file(USERS_FILE, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    if (!in_array($user_id, $users)) {
        file_put_contents(USERS_FILE, $user_id . PHP_EOL, FILE_APPEND);
    }
}

function save_group($group_id) {
    if (!file_exists(GROUPS_FILE)) {
        file_put_contents(GROUPS_FILE, '');
    }
    
    $groups = file(GROUPS_FILE, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    if (!in_array($group_id, $groups)) {
        file_put_contents(GROUPS_FILE, $group_id . PHP_EOL, FILE_APPEND);
    }
}

function add_blocked($user_id) {
    if (!file_exists(BLOCKED_FILE)) {
        file_put_contents(BLOCKED_FILE, '');
    }
    
    $blocked = file(BLOCKED_FILE, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    if (!in_array($user_id, $blocked)) {
        file_put_contents(BLOCKED_FILE, $user_id . PHP_EOL, FILE_APPEND);
    }
}

function remove_blocked($user_id) {
    if (!file_exists(BLOCKED_FILE)) {
        return;
    }
    
    $blocked = file(BLOCKED_FILE, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    $blocked = array_diff($blocked, [$user_id]);
    file_put_contents(BLOCKED_FILE, implode(PHP_EOL, $blocked));
}

function is_blocked($user_id) {
    if (!file_exists(BLOCKED_FILE)) {
        return false;
    }
    
    $blocked = file(BLOCKED_FILE, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    return in_array($user_id, $blocked);
}

function set_bot_status($status) {
    file_put_contents(BOT_STATUS_FILE, $status ? 'enabled' : 'disabled');
}

function get_bot_status() {
    if (!file_exists(BOT_STATUS_FILE)) {
        return true;
    }
    
    return trim(file_get_contents(BOT_STATUS_FILE)) === 'enabled';
}

function set_pending_action($user_id, $action) {
    $pending = [];
    if (file_exists(PENDING_FILE)) {
        $pending = json_decode(file_get_contents(PENDING_FILE), true) ?: [];
    }
    
    $pending[$user_id] = $action;
    file_put_contents(PENDING_FILE, json_encode($pending));
}

function get_pending_action($user_id) {
    if (!file_exists(PENDING_FILE)) {
        return null;
    }
    
    $pending = json_decode(file_get_contents(PENDING_FILE), true);
    return $pending[$user_id] ?? null;
}

function clear_pending_action($user_id) {
    if (!file_exists(PENDING_FILE)) {
        return;
    }
    
    $pending = json_decode(file_get_contents(PENDING_FILE), true) ?: [];
    if (isset($pending[$user_id])) {
        unset($pending[$user_id]);
        file_put_contents(PENDING_FILE, json_encode($pending));
    }
}

function get_gold_price() {
    global $GOLD_API_URL;
    
    try {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, GOLD_API_URL);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if ($httpCode !== 200) {
            return null;
        }
        
        $data = json_decode($response, true);
        
        if (!$data || !isset($data['ok']) || !$data['ok']) {
            return null;
        }
        
        foreach ($data['result'] as $item) {
            if (isset($item['title']) && strtolower($item['title']) === 'طلای 18 عیار / 750') {
                return $item['price'][0] ?? 0;
            }
        }
        
        return null;
    } catch (Exception $e) {
        error_log("Error getting gold price: " . $e->getMessage());
        return null;
    }
}

function get_coin_data() {
    global $FAST_API_URL;
    
    try {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $FAST_API_URL);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36');
        
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $curlError = curl_error($ch);
        curl_close($ch);
        
        error_log("API Response - HTTP Code: $httpCode");
        error_log("API Response: " . substr($response, 0, 200));
        
        if ($httpCode !== 200) {
            error_log("HTTP Error: $httpCode, cURL Error: $curlError");
            return null;
        }
        
        $data = json_decode($response, true);
        
        if (!$data) {
            error_log("JSON Parse Error");
            return null;
        }
        
        if (isset($data['result'])) {
            $coins = [];
            foreach ($data['result'] as $sym => $coin_data) {
                if (is_array($coin_data)) {
                    $sym_lower = strtolower($sym);
                    $coins[$sym_lower] = $coin_data;
                    
                    if (isset($coin_data['name'])) {
                        $name_lower = strtolower($coin_data['name']);
                        $coins[$name_lower] = $coin_data;
                    }
                }
            }
            return $coins;
        }
        
        return null;
        
    } catch (Exception $e) {
        error_log("Error getting coin data: " . $e->getMessage());
        return null;
    }
}

function sendMessage($chat_id, $text, $parse_mode = null, $reply_markup = null) {
    $url = API_URL . "sendMessage";
    
    $data = [
        'chat_id' => $chat_id,
        'text' => $text
    ];
    
    if ($parse_mode) {
        $data['parse_mode'] = $parse_mode;
    }
    
    if ($reply_markup) {
        $data['reply_markup'] = $reply_markup;
    }
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_exec($ch);
    curl_close($ch);
}

function forwardMessage($chat_id, $from_chat_id, $message_id) {
    $url = API_URL . "forwardMessage";
    
    $data = [
        'chat_id' => $chat_id,
        'from_chat_id' => $from_chat_id,
        'message_id' => $message_id
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_exec($ch);
    curl_close($ch);
}

function broadcast_to_users($text) {
    if (!file_exists(USERS_FILE)) {
        return 0;
    }
    
    $users = file(USERS_FILE, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    $success = 0;
    
    foreach ($users as $user_id) {
        if (is_blocked($user_id)) {
            continue;
        }
        
        try {
            sendMessage($user_id, $text, 'HTML');
            $success++;
            usleep(200000); 
        } catch (Exception $e) {
            continue;
        }
    }
    
    return $success;
}

function forward_to_all($from_chat_id, $message_id) {
    $forwarded = 0;
    
    if (file_exists(USERS_FILE)) {
        $users = file(USERS_FILE, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        
        foreach ($users as $user_id) {
            if (is_blocked($user_id)) {
                continue;
            }
            
            try {
                forwardMessage($user_id, $from_chat_id, $message_id);
                $forwarded++;
                usleep(150000); 
            } catch (Exception $e) {
                continue;
            }
        }
    }
    
    if (file_exists(GROUPS_FILE)) {
        $groups = file(GROUPS_FILE, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        
        foreach ($groups as $group_id) {
            try {
                forwardMessage($group_id, $from_chat_id, $message_id);
                $forwarded++;
                usleep(150000); 
            } catch (Exception $e) {
                continue;
            }
        }
    }
    
    return $forwarded;
}

function get_target_user_id($message) {
    if (isset($message['reply_to_message'])) {
        return $message['reply_to_message']['from']['id'];
    }
    
    $text = trim($message['text']);
    if (is_numeric($text)) {
        return (int)$text;
    }
    
    if (isset($message['forward_from'])) {
        return $message['forward_from']['id'];
    }
    
    return null;
}

function format_number($number, $decimals = 2) {
    $formatted = number_format($number, $decimals);
    return rtrim(rtrim($formatted, '0'), '.');
}

// Telegram Channel : @ZetaB0t
// Developer : @SpiderM9n
?>